'use client';
import React, { useEffect, useState } from 'react';
import { useRouter } from 'next/navigation';
import Sidebar from '@/app/Components/Home/Sidebar';
import Header from '@/app/Components/Home/Header';
import Link from 'next/link';
import withAuth from '../../Components/Home/withAuth';
import axios from 'axios';
import 'bootstrap/dist/css/bootstrap.min.css'; // Make sure Bootstrap is imported
import apiRequest from '@/app/lib/InterceptorAxios/axios';
import LoadingSkeletonTable from '../loading';
const CompaniesPage = () => {
  const router= useRouter();
  const [companies, setCompanies] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [showModal, setShowModal] = useState(false);
  const [newCompany, setNewCompany] = useState({
    name: '',
    location: '',
    representative :'',
    statusId: 1,
  });
  const [editingCompany, setEditingCompany] = useState(null);
  const [showEditModal, setShowEditModal] = useState(false);
  useEffect(() => {
    sessionStorage.clear()
    // const fetchCompanies = async () => {
    //   try {
    //     const response = await axios-get(`${process.env.NEXT_PUBLIC_API_URL}/api/companies`); // Adjust the API endpoint as needed
    //     setCompanies(response.data);
         
    //     setLoading(false);
    //   } catch (error) {
    //     console.error('Error fetching companies:', error);
    //     setError('Failed to fetch companies');
    //     setLoading(false);
    //   }
    // };
    const fetchCompanies = async () => {
      try {
        const companies = await apiRequest('/api/companies', 'GET');
        setCompanies(companies);
        setLoading(false);
      } catch (error) {
        console.error('Error fetching companies:', error.message);
        setError(error.message);
        setLoading(false);
      }
    };
    fetchCompanies();
  }, []);

  const handleInputChange = (e) => {
    const { name, value } = e.target;
    setNewCompany({ ...newCompany, [name]: value });
  };

  // const handleAddCompany = async () => {
  //   try {
  //     const response = await axios-post(`${process.env.NEXT_PUBLIC_API_URL}/api/companies`, newCompany);
  //     setCompanies([...companies, response.data]);
  //     setShowModal(false);
  //     setNewCompany({ name: '', location: '', statusId: 1 });
  //     const updateresponse = await axios.get(`${process.env.NEXT_PUBLIC_API_URL}/api/companies`); // Adjust the API endpoint as needed
  //       setCompanies(updateresponse.data);
  //   } catch (error) {
  //     console.error('Error adding company:', error);
  //     setError('Failed to add company');
  //   }
  // };
  const handleAddCompany = async (event) => {
    event.preventDefault(); // Prevent form from reloading the page
    try {
      if (
        !newCompany.name ||
        !newCompany.representative ||
        !newCompany.location ||
        newCompany.statusId === ""
      ) {
        swal("Error","All fields are required.","error");
        return;
      }
      const newCompanyData = await apiRequest('/api/companies', 'POST', newCompany);
      setCompanies([...companies, newCompanyData]);
  
      const updatedCompanies = await apiRequest('/api/companies', 'GET');
      setCompanies(updatedCompanies);
  
      setShowModal(false);
      setNewCompany({ name: '', location: '', statusId: 1 });
  
      swal("Success!", "Company added successfully.", "success");
    } catch (error) {
      console.error('Error adding company:', error.message);
      setError(error.message);
    }
  };
  const handleUpdateCompany = async (event) => {
    event.preventDefault(); // Prevent form from reloading the page
    try {
      if (
        !editingCompany.name ||
        !editingCompany.representative ||
        !editingCompany.location ||
        editingCompany.statusId === ""
      ) {
        swal("Error","All fields are required.","error");
        return;
      }
      const updatecompanyData = {
      name:  editingCompany.name,
      representative: editingCompany.representative,
      location: editingCompany.location,
      statusId: editingCompany.statusId,
      }
      const newCompanyData = await apiRequest(`/api/companies/${editingCompany.id}`, 'PUT', updatecompanyData);
      // setEditingCompany([...companies, newCompanyData]);
      setCompanies([...companies.filter(c => c.id !== newCompanyData.id), newCompanyData]);
      const updatedCompanies = await apiRequest('/api/companies', 'GET');
      setCompanies(updatedCompanies);
  
      setShowModal(false);
      setNewCompany({ name: '', location: '', statusId: 1 });
      setShowEditModal(false);
      swal("Success!", "Company added successfully.", "success");
      setEditingCompany(null)
    } catch (error) {
      console.error('Error adding company:', error.message);
      setError(error.message);
    }
  };
  const handleEditInputChange = (e) => {
    const { name, value } = e.target;
    setEditingCompany({ ...editingCompany, [name]: value });
  };
  const handleEditCompany = (company) => {
    setEditingCompany(company);
    
    
    setShowEditModal(true);
  };
  const formatDate = (dateString) => {
    const options = { year: 'numeric', month: 'short', day: 'numeric' };
    return new Date(dateString).toLocaleDateString(undefined, options);
  };


  // Helper function to encode the company name
const encodeCompanyName = (name) => encodeURIComponent(name);
  if (loading) {
    return <LoadingSkeletonTable/>
  }

  if (error) {
    return <div>Error: {error}</div>;
  }

  return (
    <>
    
 
        <div className="container-fluid top-bar">
          <div className="left-div">
            <h2>Companies</h2>
          </div>
        </div>
        <div className="container-fluid company-header">
          <div className="comp-header-row">
            <button className="btn p-btn" onClick={() => setShowModal(true)}>
              Add
            </button>
          </div>
        </div>

        <div className="container-fluid">
          <table className="table table-striped mt-4">
            <thead>
              <tr>
                <th>Name</th>
                <th>Representative</th>
                <th>Location</th>
                <th>Created At</th>
                <th>Status</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              {companies.map((company) => (
                <tr key={company.id}>
                  <td>{company.name}</td>
                  <td>{company.representative}</td>
                  <td>{company.location}</td>
                  <td>{formatDate(company.created_at)}</td>
                  <td>{company.status === 1 ? 'Active' : 'Inactive'}</td>
                  <td className='table-end-buttons'>
                  <button
              className="btn btn-sm p-btn"
              onClick={() => {
                // Store company data in sessionStorage
                sessionStorage.setItem('companyData', JSON.stringify({ name: company.name, comp_id:company.id }));
                router.push(`/company-management/${company.id}`);
              }}
            >
              View
            </button> 
              <button
              className="btn btn-sm p-btn"
             
                onClick={() => handleEditCompany(company)}
              
            >
              Edit
            </button>
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
   

      {/* Add Company Modal */}
       {/* Modal */}
       {showModal && (
       <div className="modal-overlay-comp">
       <div className="modal-comp">
         <div className="modal-header-comp">
           <h5 className="modal-title">Add Company</h5>
           <button
             type="button"
             className="modal-close"
             onClick={() => setShowModal(false)}
           >
             &times;
           </button>
         </div>
         <form onSubmit={handleAddCompany}>
           <div className="modal-body">
             <div className="form-group">
               <label htmlFor="name">Name</label>
               <input
                 type="text"
                 className="form-control"
                 id="name"
                 name="name"
                 value={newCompany.name}
                 onChange={handleInputChange}
                 required
               />
             </div>
             <div className="form-group">
               <label htmlFor="representative">Representative</label>
               <input
                 type="text"
                 className="form-control"
                 id="representative"
                 name="representative"
                 value={newCompany.representative}
                 onChange={handleInputChange}
                 required
               />
             </div>
             <div className="form-group">
               <label htmlFor="location">Location</label>
               <input
                 type="text"
                 className="form-control"
                 id="location"
                 name="location"
                 value={newCompany.location}
                 onChange={handleInputChange}
                 required
               />
             </div>
             <div className="form-group">
               <label htmlFor="statusId">Status</label>
               <select
                 className="form-control"
                 id="statusId"
                 name="statusId"
                 value={newCompany.statusId}
                 onChange={handleInputChange}
                 required
               >
                 {/* <option value="">Select Status</option> */}
                 <option value={1}>Active</option>
                 <option value={0}>Inactive</option>
               </select>
             </div>
           </div>
           <div className="modal-footer-comp">
             <button type="submit" className="btn p-btn">
               Add Company
             </button>
           </div>
         </form>
       </div>
     </div>
     
)}
{/* edit modal  */}
{showEditModal && (
       <div className="modal-overlay-comp">
       <div className="modal-comp">
         <div className="modal-header-comp">
           <h5 className="modal-title">Edit Company</h5>
           <button
             type="button"
             className="modal-close"
             onClick={() => setShowEditModal(false)}
           >
             &times;
           </button>
         </div>
         <form onSubmit={handleUpdateCompany}>
           <div className="modal-body">
             <div className="form-group">
               <label htmlFor="name">Name</label>
               <input
                 type="text"
                 className="form-control"
                 id="name"
                 name="name"
                 value={editingCompany.name}
                 onChange={handleEditInputChange}
                 required
               />
             </div>
             <div className="form-group">
               <label htmlFor="representative">Representative</label>
               <input
                 type="text"
                 className="form-control"
                 id="representative"
                 name="representative"
                 value={editingCompany.representative}
                 onChange={handleEditInputChange}
                 required
               />
             </div>
             <div className="form-group">
               <label htmlFor="location">Location</label>
               <input
                 type="text"
                 className="form-control"
                 id="location"
                 name="location"
                 value={editingCompany.location}
                 onChange={handleEditInputChange}
                 required
               />
             </div>
             <div className="form-group">
               <label htmlFor="statusId">Status</label>
               <select
                 className="form-control"
                 id="statusId"
                 name="statusId"
                 value={editingCompany.status}
                 onChange={handleEditInputChange}
                 required
               >
                 <option value="">Select Status</option>
                 <option value={1}>Active</option>
                 <option value={0}>Inactive</option>
               </select>
             </div>
           </div>
           <div className="modal-footer-comp">
             <button type="submit" className="btn p-btn">
               Update Company
             </button>
           </div>
         </form>
       </div>
     </div>
     
)}
    </>
  );
};

// export default withAuth(CompaniesPage, [1]);
export default CompaniesPage;
