import axios from "axios";
import { getCookie } from "cookies-next";
import { useParams } from "next/navigation";
import React, { useEffect, useState } from "react";
import { useSelector } from "react-redux";

const EditBrand = ({ brand,setUpdateBrand }) => {
    const [editBrandModalShow, setEditBrandModalShow] = useState(false);
    const token = getCookie('token');
    
    const [EditbrandFormData, setEditbrandFormData] = useState({
        brandId:brand.id,
        name: brand.name || "",
        url: brand.url || "",
        domain_name: brand.domain_name || "",
        phone: brand.phone || "",
        email: brand.email || "",
        timeZone: brand.timeZone || "US/Pacific",
        statusId: brand.statusId || 1,
        logoUrl: brand.logoUrl || "",
        logo: null,
    });
    const user = useSelector((state) => state.user.userInfo);
    const [logoOption, setLogoOption] = useState("upload");

    const timezones = [
        { zone: "US/Pacific", gmt: "GMT-8" },
        { zone: "US/Mountain", gmt: "GMT-7" },
        { zone: "US/Central", gmt: "GMT-6" },
        { zone: "US/Eastern", gmt: "GMT-5" },
    ];

    const handleEditBrandClick = () => setEditBrandModalShow(true);

    // const handleBrandInputChange = (e) => {
    //     const { name, value } = e.target;
    //     setEditbrandFormData((prev) => ({
    //         ...prev,
    //         [name]: value,
    //     }));
    // };
    

    // const handleBrandFileChange = (e) => {
    //     const file = e.target.files[0];
    //     setEditbrandFormData((prev) => ({
    //         ...prev,
    //         logo: file,
    //         logoUrl: "", // Clear URL if a file is selected
    //     }));
    // };
  
    // const handleLogoOptionChange = (option) => {
    //     setLogoOption(option);
    //     setEditbrandFormData((prev) => ({
    //         ...prev,
    //         logo: option === "upload" ? null : prev.logo,  // Clear uploaded file if "url" is selected
    //         logoUrl: option === "url" ? "" : prev.logoUrl, // Clear URL if "upload" is selected
    //     }));
    // };
    const handleLogoOptionChange = (option) => {
        setLogoOption(option);
    
        if (option === "url") {
            // When URL option is selected, clear the uploaded image (logo)
            setEditbrandFormData((prev) => ({
                ...prev,
                logo: null, // Clear uploaded image
            }));
        } else if (option === "upload") {
            // When Upload option is selected, clear the URL
            setEditbrandFormData((prev) => ({
                ...prev,
                logoUrl: "", // Clear URL field
            }));
        }
    };
    
    const handleBrandFileChange = (event) => {
        const file = event.target.files[0];
        if (file) {
            setEditbrandFormData((prev) => ({
                ...prev,
                logo: file,
                logoUrl: "",  // Clear URL when a file is uploaded
            }));
        }
    };
    
    const handleBrandInputChange = (event) => {
        const { name, value, type, checked } = event.target;
    
        if (type === "checkbox") {
            // If checkbox for URL is checked, update `logoUrl` and clear `logo`
            setEditbrandFormData((prev) => ({
                ...prev,
                logoUrl: checked ? value : "", // Set URL if checked, else clear
                logo: null,  // Clear uploaded image when URL is selected
            }));
        } else {
            // For other input fields (like URL input), update the corresponding field dynamically
            setEditbrandFormData((prev) => ({
                ...prev,
                [name]: value, // Update the correct field (logoUrl or other)
            }));
        }
    };
    
    
    useEffect(() => {
        if (editBrandModalShow) {
            
            document.querySelectorAll('.table-striped tr').forEach(row => {
                row.classList.add('tr-static');
                row.style.position = 'static';
            });
        } else {
        
            document.querySelectorAll('.table-striped tr').forEach(row => {
                row.classList.remove('tr-static');
                row.style.position = 'sticky';
            });
        }
    }, [editBrandModalShow]);
      

    const handleBrandSubmit = async (e) => {
        e.preventDefault();
      
        if (user.userId) {
          const formDataWithFile = new FormData();
          formDataWithFile.append('name', EditbrandFormData.name);
          formDataWithFile.append('brandId', EditbrandFormData.brandId);
          formDataWithFile.append('url', EditbrandFormData.url);
          formDataWithFile.append('domainName', EditbrandFormData.domain_name);
          formDataWithFile.append('phone', EditbrandFormData.phone);
          formDataWithFile.append('email', EditbrandFormData.email);
          formDataWithFile.append('timeZone', EditbrandFormData.timeZone);
          formDataWithFile.append('logo', EditbrandFormData.logo);
          formDataWithFile.append('logoUrl', EditbrandFormData.logoUrl);
        //   formDataWithFile.append('company_id', companyid);
          formDataWithFile.append('status', EditbrandFormData.statusId);
          formDataWithFile.append('updated_by', user.userId);
            
            
          try {
            await axios.put(`${process.env.NEXT_PUBLIC_API_URL}/api/brands`, formDataWithFile, {
              headers: {
                'Content-Type': 'multipart/form-data',
                Authorization: `Bearer ${token}`,
              },
            });
      
            swal("Success!", "Brand has been Updated successfully!", "success");
      
            setEditBrandModalShow(false);
            setUpdateBrand(true)
      
            // const response = await axios.get(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/${companyid}/brands`, {
            //   headers: {
            //     Authorization: `Bearer ${token}`,
            //   },
            // });
      
            // setBrands(response.data);
          } catch (error) {
            if(error.response.status === 401){
                // Show SweetAlert for "Email already exists" error
            swal("Oops!", "Something went wrong please reload page and try again..", "error");
            }
            else{

                swal("Error", `Error creating brand: ${error.response ? error.response.data.error : error.message}`, "error");
                console.error('Error creating brand:', error);
            }
          }
        } else {
          console.error("User is missing");
        }
      };
    return (
        <>
            <button
                className="btn btn-sm p-0 mx-2 text-sm-center py-2 px-1   p-btn w-100"
                onClick={handleEditBrandClick}
            >
                Edit
            </button>

            {editBrandModalShow && (
                <div className="modal-overlay-comp">
                    <div className="modal-brand">
                        <div className="modal-header-comp">
                            <h5 className="modal-title">Edit Brand</h5>
                            <button
                                type="button"
                                className="modal-close"
                                onClick={() => setEditBrandModalShow(false)}
                            >
                                &times;
                            </button>
                        </div>
                        <div className="modal-body">
                            <form onSubmit={handleBrandSubmit}>
                                <div className="form-group-row-2">
                                    <div className="form-group">
                                        <label htmlFor="name">Brand Name</label>
                                        <input
                                            className="form-control"
                                            type="text"
                                            id="name"
                                            name="name"
                                            value={EditbrandFormData.name}
                                            onChange={handleBrandInputChange}
                                            required
                                        />
                                    </div>
                                    <div className="form-group">
                                        <label htmlFor="url">URL</label>
                                        <input
                                            type="text"
                                            className="form-control"
                                            id="url"
                                            name="url"
                                            value={EditbrandFormData.url}
                                            onChange={handleBrandInputChange}
                                            required
                                        />
                                    </div>
                                </div>
                                <div className="form-group-row-2">
                                    <div className="form-group">
                                        <label htmlFor="domain_name">Domain</label>
                                        <input
                                            type="text"
                                            className="form-control"
                                            id="domain_name"
                                            name="domain_name"
                                            value={EditbrandFormData.domain_name}
                                            onChange={handleBrandInputChange}
                                            required
                                        />
                                    </div>
                                    <div className="form-group">
                                        <label htmlFor="phone">Phone</label>
                                        <input
                                            className="form-control"
                                            type="text"
                                            id="phone"
                                            name="phone"
                                            value={EditbrandFormData.phone}
                                            onChange={handleBrandInputChange}
                                            required
                                        />
                                    </div>
                                </div>
                                <div className="form-group">
                                    <label htmlFor="email">Email</label>
                                    <input
                                        type="email"
                                        className="form-control"
                                        id="email"
                                        name="email"
                                        value={EditbrandFormData.email}
                                        onChange={handleBrandInputChange}
                                        required
                                    />
                                </div>
                                <div className="form-group">
                                    <label htmlFor="timeZone">Time Zone</label>
                                    <select
                                        className="form-control"
                                        id="timeZone"
                                        name="timeZone"
                                        value={EditbrandFormData.timeZone}
                                        onChange={handleBrandInputChange}
                                    >
                                        {timezones.map((tz) => (
                                            <option key={tz.zone} value={tz.zone}>
                                                {tz.gmt} {tz.zone}
                                            </option>
                                        ))}
                                    </select>
                                </div>
                                <div className="form-group">
                                    <label htmlFor="statusId">Status</label>
                                    <select
                                        className="form-control"
                                        id="statusId"
                                        name="statusId"
                                        value={EditbrandFormData.statusId}
                                        onChange={handleBrandInputChange}
                                    >
                                        <option value={1}>Active</option>
                                        <option value={0}>Inactive</option>
                                    </select>
                                </div>
                                <div className="form-group">
        <label>Brand Logo</label>

        {/* Display the uploaded image (if available) */}
        {EditbrandFormData.logo && (
            <div className="brand-uploaded-image">
                <span>Uploaded Image:</span>
                <img src={URL.createObjectURL(EditbrandFormData.logo)} alt="Uploaded Brand Logo" className="current-logo" />
            </div>
        )}

        {/* Display the image from the provided URL (if available) */}
        {EditbrandFormData.logoUrl && (
            <div className="brand-uploaded-image">
                <span>Image from URL:</span>
                <img src={EditbrandFormData.logoUrl} alt="Brand Logo from URL" className="current-logo" />
            </div>
        )}

        {/* If no uploaded image or URL image, show the default brand logo */}
        {!EditbrandFormData.logo && !EditbrandFormData.logoUrl && brand.logo && (
            <div className="brand-uploaded-image">
                <span>Current Brand Logo:</span>
                <img src={brand.logo} alt="Original Brand Logo" className="current-logo" />
            </div>
        )}

        <div className="brand-logo-container">
            <div className="form-check">
                <label>Upload from Device</label>
                <input
                    type="radio"
                    name="logoOption"
                    value="upload"
                    checked={logoOption === "upload"}
                    onChange={() => handleLogoOptionChange("upload")}
                />
            </div>

            <div className="form-check">
                <label>Provide a URL</label>
                <input
                    type="radio"
                    name="logoOption"
                    value="url"
                    checked={logoOption === "url"}
                    onChange={() => handleLogoOptionChange("url")}
                />
            </div>
        </div>

        {/* Show file upload if "upload" is selected */}
        {logoOption === "upload" && (
            <input type="file" name="logo" onChange={handleBrandFileChange} accept="image/*" />
        )}

        {/* Show URL input if "Provide a URL" is selected */}
        {logoOption === "url" && (
            <input
                className="form-control"
                type="url"
                name="logoUrl"
                value={EditbrandFormData.logoUrl}
                onChange={handleBrandInputChange}
                placeholder="Enter image URL"
            />
        )}
    </div>

                                <button type="submit" className="btn submit-btn p-btn mt-3 w-100">
                                    Update Brand
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            )}
        </>
    );
};

export default EditBrand;
