import React, { useState, useEffect, useRef } from "react";
 
import { AiFillDislike, AiFillLike, AiOutlineLike } from "react-icons/ai";
import { FaCheckDouble } from "react-icons/fa6";

 
import { useSelector } from "react-redux";
 
import MessageFile from "../MessageFile";
 
import HistoryChatMeta from "./HistoryChatMeta";
import apiRequest from "@/app/lib/InterceptorAxios/axios";
const SessionChat = ({
  chat_session_id,
  currentChat,
  setHideColumns,
  setCurrentChat,
  updateIpHealth,
}) => {
 
  const [messages, setMessages] = useState([]);
  
   
  const user = useSelector((state) => state.user.userInfo);
 const [Rating, setRating] = useState(2)
  // Fetch chat history when the component mounts
  useEffect(() => {
    setMessages([])
    if(chat_session_id){
        fetchChatHistory()
    }
  }, [chat_session_id])
  
  const fetchChatHistory = async () => {
    
 
    try {
      const data=await apiRequest('/api/chat/messages-by-session-id','POST',{
        session_id: chat_session_id,
      })
      
      
      
      if (data.messages) {
        
         setMessages(data.messages)
      }
      setRating(data.rating)
    } catch (error) {
      console.error("Error fetching chat history:", error);
    }  
  };

  function convertUtcToLocal(utcTimestamp, locale = "en-US") {
    const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
    const date = new Date(utcTimestamp);

    const now = new Date();

    // Create local copies of today and yesterday's start
    const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
    const yesterday = new Date(today);
    yesterday.setDate(today.getDate() - 1);

    // Formatting options
    const timeOptions = {
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      timeZone,
    };
    const dateOptions = {
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      timeZone,
    };

    // Check if the timestamp is from today
    if (date >= today) {
      return `Today ${date.toLocaleTimeString(locale, timeOptions)}`;
    }

    // Check if the timestamp is from yesterday
    if (date >= yesterday && date < today) {
      return `Yesterday ${date.toLocaleTimeString(locale, timeOptions)}`;
    }

    // For timestamps older than yesterday, return date + time
    return `${date.toLocaleDateString(
      locale,
      dateOptions
    )} ${date.toLocaleTimeString(locale, timeOptions)}`;
  }
   

 

 

  // Add a useEffect to handle showing the notification icon
 
 

 

  

 
 
 
  // This function checks if a click is outside the emoji picker
 
   

 
   const [file, setFile] = useState(null);

  // Function to handle file selection
   // Handle file selection
 
  
  

  // Handle sending a file through socket
 
  // Handle message sending 

  return (
    <div className="grid-history-container">
      <div className="visitor-box-left">
        <div className="visitor-chat-box chat-box chat-visitor-item-1">
          <div className="visitorChat-header" style={{ padding: "5px" }}>
            <div
              className="d-flex align-items-center justify-content-between w-100"
              style={{ position: "relative" }}
            >
              <span style={{ visibility: "hidden", fontSize: "12px" }}>
                12:30 PM
              </span>
              <span style={{ fontSize: "12px" }}>
                {/* Visitor {currentChat?.chatId} has Joined */}
              </span>
              <span style={{ fontSize: "12px", width: "20%" }}>
                {/* {currentChat?.join_time} */}
              </span>
            </div>
          </div>

          <div
            className="chat-messages"
     
            
            style={{ overflowY: "auto", position: "relative" }}
          >
         
           

{messages
  .slice()
  .reverse()
  .map((message, index) => (
    <React.Fragment key={index}>
      {message.msgtype === "comment" ? (
        <div style={{ textAlign: "center" }}>
          <div className="comment-message" style={{ margin: "5px 0", color: "rgb(159 159 159)" }}>
            <p>{message.msg}</p>
            <small>{convertUtcToLocal(message.sent_at)}</small>
          </div>
        </div>
      ) : (
        
        <div
        className={`message-bubble ${
          message.type === "admin" && message.from === user?.pseudonym
            ? "admin-message-right" // Admin's own message aligned right
            : message.type === "admin" || message.msgtype === "auto-reply"
            ? "admin-message" // Admin and auto-reply messages aligned left
            : "client-message" // Visitor message aligned left
        }`}
      >
        <div className="chat-message-left">
          <span style={{ fontSize: "10px", color: "#888" }}>
            {message.msgtype === "auto-reply"
              ? "System"
              : message.type === "admin" && message.from === user?.pseudonym
              ? "You"
              : message.type === "admin"
              ? message.from
              : "Visitor"}
          </span>


          {message.msgtype === "file" ? (
          <MessageFile message={message}/>
          ) : (
            <p className="m-0 user-msg">{message.msg}</p>
          )}
            {message.is_seen === 1 && message.type =='admin' && (
            <span className="message-seen-tick"><FaCheckDouble size={10} color="#53bdeb" />
</span> // Double tick mark or "Seen" label
          )}
  </div>  
  <div className="chat-message-right">

  
          <span style={{ fontSize: "10px", color: "#888" }}>
            {convertUtcToLocal(message.sent_at)}
          </span>
          </div>
          {/* Show tick mark or "Seen" label if the message is seen */}
        
        </div>
      )}
    </React.Fragment>
  ))}


        
          </div>
        </div>
        <div className="panel-input-box chat-visitor-item-2 mt-2">
          <div style={{ placeContent: "flex-end", height: "100%" }}>
            <div>
             
            </div>
            <div
              className="d-flex p-2 border align align-items-center"
              style={{ fontSize: "11px" }}
            >
              
              <div
                style={{ flex: 3, cursor: "pointer" }}
                className="d-flex justify-content-end"
              >
                {/* Button to show emoji picker */}
                {/* Button to show emoji picker */}
                

                {/* Emoji picker dropdown */}
              
                    {/* Conditionally render based on rating state */}
      <span className={`px-2 chat-extra-btns ${Rating === 3 ? 'no-rating-given' : ''}`}>
        {Rating === 1 && (
          <>
            <AiFillLike style={{ marginRight: '1px', fontSize: '15px', color: 'green' }} />
            <span style={{color:'green'}}>Rating</span>
          </>
        )}

        {Rating === 0 && (
          <>
            <AiFillDislike style={{ marginRight: '1px', fontSize: '15px', color: 'red' }} />
            <span style={{color:'red'}}>Rating</span>
          </>
        )}

        {Rating === 2 && (
          <>
            <AiOutlineLike style={{ marginRight: '1px', fontSize: '15px' }} />
            <span>Rating</span>
          </>
        )}
      </span>

      
                 {/* Button to open file input */}
    
      {/* Hidden file input for selecting image files */}
   

      {/* Show a preview of the selected file (if any) */}
     
              </div>
            </div>
          </div>
        </div>
      </div>
      {/* clientId, publicKey ,currentChat  */}
      <HistoryChatMeta
      clientId={currentChat?.client_id}
      setHideColumns={setHideColumns}
      setCurrentChat={setCurrentChat}
      updateIpHealth={updateIpHealth} // Pass updateIpHealth down
      publicKey={currentChat?.public_key}
      currentChat={currentChat}
      />
      {/* <VisitorMeta  clientId ={currentChat.client_id} publicKey ={currentChat.public_key} currentChat ={currentChat} user={user}  /> */}
    </div>
  );
};

export default SessionChat;
