import React from 'react';
import styles from './LoadingSkeletonTable.module.css';

const LoadingSkeletonTable = () => {
  return (
    <div className={styles.container}>
      <table className={styles.skeletonTable}>
        <thead>
          <tr>
            <th><div className={styles.skeletonBox}></div></th>
            <th><div className={styles.skeletonBox}></div></th>
            <th><div className={styles.skeletonBox}></div></th>
            <th><div className={styles.skeletonBox}></div></th>
            <th><div className={styles.skeletonBox}></div></th>
            <th><div className={styles.skeletonBox}></div></th>
            <th><div className={styles.skeletonBox}></div></th>
            <th><div className={styles.skeletonBox}></div></th>
          </tr>
        </thead>
        <tbody>
          {[...Array(8)].map((_, index) => (
            <tr key={index} className={styles.skeletonRow}>
              {[...Array(8)].map((_, index) => (
                <td key={index} className={styles.skeletonCell}>
                  <div className={styles.skeletonBox}>
                    <div className={styles.skeletonAnimation}></div>
                  </div>
                </td>
              ))}
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
};

export default LoadingSkeletonTable;
