'use client';
import React, { useState } from 'react';
import { Modal, Button, Image, Row, Col } from 'react-bootstrap';

const ProfileImageSelectorModal = ({ show, onHide, imagePaths, onSelect, backendUrl }) => {
  const [selectedPath, setSelectedPath] = useState(null);

  return (
    <Modal show={show} onHide={onHide} centered size="lg">
      <Modal.Header closeButton>
        <Modal.Title>Select Profile Image</Modal.Title>
      </Modal.Header>
      <Modal.Body>
        <Row className="g-3">
          { }
          {imagePaths.images.map((img, index) => (
            <Col key={index} xs={3} className="text-center">
              <Image
                src={`${backendUrl}/${img.image_url}`} // Extracting image_url
                roundedCircle
                fluid
                className={`cursor-pointer ${selectedPath === img.image_url ? 'border border-primary' : ''}`}
                style={{ width: '80px', height: '80px', cursor: 'pointer' }}
                onClick={() => setSelectedPath(img.image_url)}
              />
            </Col>
          ))}
        </Row>
      </Modal.Body>
      <Modal.Footer>
        <Button variant="secondary" onClick={onHide}>Cancel</Button>
        <Button 
          variant="primary" 
          onClick={() => onSelect(selectedPath)}
          disabled={!selectedPath}
        >
          Select
        </Button>
      </Modal.Footer>
    </Modal>
  );
};

export default ProfileImageSelectorModal;
