'use client';
import React, { useEffect, useState } from 'react';
import { Modal, Button, Form, Container, Row, Col, Card, Image } from 'react-bootstrap';
import { useSelector } from 'react-redux';
import LoadingSkeletonTable from '../loading';
import profileImage from '@/public/assets/images/dummyprofile.png';
import apiRequest from '@/app/lib/InterceptorAxios/axios';
import { FaUpload } from 'react-icons/fa';
import ProfileImageSelectorModal from './ProfileImageSelectorModal';
import { decryptData } from '@/app/utils/DecryptData';
import axios from 'axios';
import { getCookie } from 'cookies-next';
const BACKEND_URL = process.env.NEXT_PUBLIC_API_URL;
const predefinedImages = Array.from({ length: 20 }, (_, i) => `${BACKEND_URL}/profiles/image${i + 1}.png`);

const ProfilePage = () => {
  const [showProfileModal, setShowProfileModal] = useState(false);
  const [userData, setUserData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [showProfileImageModal, setShowProfileImageModal] = useState(false);
  const [selectedProfileImage, setSelectedProfileImage] = useState(profileImage.src);
  const [profileImagePaths, setProfileImagePaths] = useState([]);
  const [ShowPasswordModal, setShowPasswordModal] = useState(false)
  const [OriginalProfileImage, setOriginalProfileImage] = useState(profileImage.src)
  
  const [formData, setFormData] = useState({
    pseudonym: '',
    name: '',
    email: '',
    designation: '',
    profile_image: '',
    profile_type: 'selected',
  });

  const user = useSelector((state) => state.user.userInfo);
  const handlePasswordChange = (e) => {
    const { name, value } = e.target;
    setPasswordData((prevData) => ({
      ...prevData,
      [name]: value
    }));
  }; const handlePasswordUpdate = async () => {
    try {
      const { currentPassword, newPassword, confirmPassword } = passwordData;
  
      if (newPassword !== confirmPassword) {
        alert("New passwords do not match!");
        return;
      }
  
      const response = await apiRequest(
        "/api/update-profile-password", // Relative URL
        "POST",
        {
          currentPassword,
          newPassword,
          confirmPassword,
          userId: user.userId,
        }
      );
  
      setPasswordData({
        currentPassword: '',
        newPassword: '',
        confirmPassword: ''
      });
      setShowPasswordModal(false); // Close modal after successful update
      alert("Password updated successfully!");
    } catch (err) {
      console.error("Error updating password:", err);
      alert(err.message); // Show error message to the user
    }
  };// State for password update form
  const [passwordData, setPasswordData] = useState({
    currentPassword: '',
    newPassword: '',
    confirmPassword: ''
  });

  useEffect(() => {
    const fetchData = async () => {
      if (!user?.userId) return;

      try {
        // Fetch user profile
        const profileResponse = await apiRequest(`/api/get-profile/${user.userId}`, "GET");
        setUserData(profileResponse);
        setFormData({
          pseudonym: profileResponse.pseudonym || '',
          name: profileResponse.name || '',
          email: profileResponse.email || '',
          designation: profileResponse.designation || '',
          profile_image: profileResponse.profile || '',
          profile_type: profileResponse.profile_type,
        });
        
        
        
        setSelectedProfileImage(profileResponse.profile ? `${BACKEND_URL}/${profileResponse.profile}` : profileImage.src);
        setOriginalProfileImage(profileResponse.profile ? `${BACKEND_URL}/${profileResponse.profile}` : profileImage.src);
        
        // Fetch available profile images
        const imagesResponse = await apiRequest('/api/profile-images', 'GET');
        
        
        const {images} = imagesResponse
        
        setProfileImagePaths(imagesResponse);
      } catch (err) {
        setError(err.message);
      } finally {
        setLoading(false);
      }
    };

    fetchData();
  }, [user?.userId]);
  const handleInputChange = (e) => {
    const { name, value } = e.target;
    setFormData((prevData) => ({
      ...prevData,
      [name]: value,
    }));
  };
  const handleProfileImageSelect = (imagePath) => {
    
    
    const cleanedImagePath = imagePath.replace('uploads/user_Profiles/', '');
    setFormData(prev => ({
      ...prev,
      profile_image: cleanedImagePath,
      profile_type: 'selected'
    }));
    setSelectedProfileImage(`${BACKEND_URL}/${imagePath}`);
    setShowProfileImageModal(false);
  };

  const handleFileChange = (event) => {
    const file = event.target.files[0];
    if (file && (file.type === "image/jpeg" || file.type === "image/png")) {
      setFormData(prev => ({
        ...prev,
        profile_image: file,
        profile_type: 'uploaded'
      }));
      setSelectedProfileImage(URL.createObjectURL(file));
    } else {
      alert("Only JPG/PNG files allowed");
    }
  };

  const handleProfileUpdate = async () => {
    try {
      const formPayload = new FormData();
      formPayload.append("userId", user.userId);
      formPayload.append("name", formData.name);
      formPayload.append("email", formData.email);
      formPayload.append("designation", formData.designation);
      formPayload.append("pseudonym", formData.pseudonym);
      formPayload.append("profile_type", formData.profile_type);
      
      if (formData.profile_type === "selected") {
        formPayload.append("existing_image", formData.profile_image); // Send the existing image path
    } else if (formData.profile_type === "uploaded") {
      formPayload.append("profile_image", formData.profile_image);
    }
    
      const response = await apiRequest("/api/update-profile", "POST", formPayload, {
        headers: { "Content-Type": "multipart/form-data" }
      });
      
      if(response.profile_image){
        setUserData(prev => ({
          ...prev,
          ...response.updatedUser,
          profile: response.profile_image
        }));
        setOriginalProfileImage(`${BACKEND_URL}/${response.profile_image}`);
      }
    else{
      setUserData(prev => ({
        ...prev,
        ...response.updatedUser,
        
      }));
    }
      setSelectedProfileImage(response.profile_image ? `${BACKEND_URL}/${response.profile_image}` : OriginalProfileImage);
      setShowProfileModal(false);
    } catch (err) {
      console.error("Update error:", err);
      alert(err.message);
    }
  };
  const handlecloseprofileUpdateModel = ()=>{
    setShowProfileModal(false)
    
    setSelectedProfileImage(OriginalProfileImage)
  }

  if (loading) return <LoadingSkeletonTable />;
  if (error) return <div>Error: {error}</div>;
  return (
    <>
       <div className="container-fluid top-bar">
          <div className="left-div">
            <h2>Profile</h2>
          </div>
          <div className="right-div"></div>
        </div>
   
    <Container className="mt-5 d-flex justify-content-center">
      <Card className="p-4 shadow-lg" style={{ maxWidth: '700px', width: "60%", borderRadius: '15px' }}>
        <Card.Body className='profile-card'>
          <Row className="mb-4 align-items-center">
            <Col md={4} className="text-center">
              <Image
                src={selectedProfileImage}
                roundedCircle
                style={{ width: '150px', height: '150px', objectFit: 'cover' }}
              />
            </Col>

            <Col md={8}>
              <Row className="mb-4 align-items-center">
                <Col>
                  {/* <h3>Profile</h3> */}
                </Col>
              </Row>
              <Row className="mb-3">
                <Col md={4} className="fw-bold">Real Name:</Col>
                <Col md={8}>{userData.name}</Col>
              </Row>
              <hr />
              <Row className="mb-3">
                <Col md={4} className="fw-bold">Pseudonym:</Col>
                <Col md={8}>{userData.pseudonym}</Col>
              </Row>
              <hr />
              
              <Row className="mb-3">
                <Col md={4} className="fw-bold">Email:</Col>
                <Col md={8}>{userData.email}</Col>
              </Row>
              <hr />
              <Row className="mb-3">
                <Col md={4} className="fw-bold">Designation:</Col>
                <Col md={8}>{userData.designation}</Col>
              </Row>
            </Col>
          </Row>
          <Row className="mb-4">
            <Col style={{   display: 'flex', justifyContent: "center", marginLeft: '-13px' }}>
              <Button variant="update-btns" className='btn btn-secondary update-btns' onClick={() => setShowPasswordModal(true)}>
                Update Password
              </Button>
            </Col>
            <Col style={{ flex: 2, marginLeft: '-13px' }}>
              <Button variant="update-btns" className='btn btn-secondary update-btns' onClick={() => setShowProfileModal(true)}>
                Edit Profile
              </Button>
            </Col>
          </Row>
        </Card.Body>
      </Card>

      {/* Edit Profile Modal */}
      <Modal show={showProfileModal} onHide={() => setShowProfileModal(false)} centered>
        <Modal.Header closeButton>
          <Modal.Title>Edit Profile</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          <Container>
            <Row>
              {/* Left Side - Input Fields */}
              <Col md={8}>
                <Form>
                  <Form.Group controlId="formName" className="mb-3">
                    <Form.Label>Real Name</Form.Label>
                    <Form.Control
                      type="text"
                      name="name"
                      value={formData.name}
                      onChange={handleInputChange}
                    />
                  </Form.Group>
                  <Form.Group controlId="formPseudonym" className="mb-3">
                    <Form.Label>Pseudonym</Form.Label>
                    <Form.Control
                      type="text"
                      name="pseudonym"
                      value={formData.pseudonym}
                      onChange={handleInputChange}
                    />
                  </Form.Group>
                  <Form.Group controlId="formDesignation" className="mb-3">
                    <Form.Label>Designation</Form.Label>
                    <Form.Control
                      type="text"
                      name="designation"
                      value={formData.designation}
                      onChange={handleInputChange}
                    />
                  </Form.Group>
                  <Form.Group controlId="formEmail" className="mb-3">
                    <Form.Label>Email</Form.Label>
                    <Form.Control
                      type="email"
                      name="email"
                      value={formData.email}
                      disabled
                    />
                  </Form.Group>
                </Form>
              </Col>

              {/* Right Side - Profile Upload */}
              <Col md={4} className="d-flex flex-column align-items-center">
  <Card className="p-3 text-center">
    <Image 
    src={selectedProfileImage || profileImage.src}
      alt="Profile" 
      roundedCircle 
      width={100} 
      height={100} 
    />
    <Button 
      variant="primary" 
      className="mt-3 mb-2 update-btns"
      onClick={() => document.getElementById('profileUpload').click()}
    >
      <FaUpload className="me-2" /> Upload 
      <input
        type="file"
        id="profileUpload"
        hidden
        onChange={handleFileChange}
      />
    </Button>
    <Button 
      variant="outline-primary" 
      className='update-btns'
      onClick={() => setShowProfileImageModal(true)}
    >
      Choose Photo
    </Button>
  </Card>
</Col>
            </Row>
          </Container>
        </Modal.Body>
        <Modal.Footer>
          <Button variant="secondary" onClick={handlecloseprofileUpdateModel}>
            Close
          </Button>
          <Button variant="primary" onClick={handleProfileUpdate}>
            Save Changes
          </Button>
        </Modal.Footer>
      </Modal>
      <ProfileImageSelectorModal
        show={showProfileImageModal}
        onHide={() => setShowProfileImageModal(false)}
        imagePaths={profileImagePaths}
        onSelect={handleProfileImageSelect}
        backendUrl={BACKEND_URL}
      />
      {/* Update Password Modal */}
      <Modal show={ShowPasswordModal} onHide={() => setShowPasswordModal(false)} centered>
        <Modal.Header closeButton>
          <Modal.Title>Update Password</Modal.Title>
        </Modal.Header>
        <Modal.Body className='update-profile-modal'>
          <Form>
            <Form.Group controlId="formCurrentPassword" className="mb-3">
              <Form.Label>Current Password</Form.Label>
              <Form.Control
                type="password"
                placeholder="Enter current password"
                name="currentPassword"
                value={passwordData.currentPassword}
                onChange={handlePasswordChange}
              />
            </Form.Group>
            <Form.Group controlId="formNewPassword" className="mb-3">
              <Form.Label>New Password</Form.Label>
              <Form.Control
                type="password"
                placeholder="Enter new password"
                name="newPassword"
                value={passwordData.newPassword}
                onChange={handlePasswordChange}
              />
            </Form.Group>
            <Form.Group controlId="formConfirmPassword" className="mb-3">
              <Form.Label>Confirm New Password</Form.Label>
              <Form.Control
                type="password"
                placeholder="Confirm new password"
                name="confirmPassword"
                value={passwordData.confirmPassword}
                onChange={handlePasswordChange}
              />
            </Form.Group>
          </Form>
        </Modal.Body>
        <Modal.Footer>
          <Button variant="secondary update-btns" onClick={() => setShowPasswordModal(false)}>
            Close
          </Button>
          <Button variant="primary update-btns" onClick={handlePasswordUpdate}>
            Update Password
          </Button>
        </Modal.Footer>
      </Modal>
    </Container>
    </>
  );
};

export default ProfilePage;
