import { use, useEffect } from 'react';
import { useRouter } from 'next/navigation';
import { getCookie } from 'cookies-next';
import axios from 'axios';
import { useDispatch, useSelector } from 'react-redux';
import { verifyUserRole } from '@/app/lib/features/user/UserSlice';
import apiRequest from '@/app/lib/InterceptorAxios/axios';

const withAuth = (WrappedComponent, requiredRole) => {
  const ComponentWithAuth = (props) => {
    const router = useRouter();
    const dispatch = useDispatch();

    useEffect(() => {
      const token = getCookie('token');
      dispatch(verifyUserRole(token));
      if (!token) {
        router.push('/login');
      } else {
        // const verifyUserRole = async () => {
        //   try {
        //     const response = await axios-post(
        //       `${process.env.NEXT_PUBLIC_API_URL}/api/auth/user-verify-role`,
        //       {},
        //       {
        //         headers: {
        //           Authorization: `Bearer ${token}`,
        //         },
        //       }
        //     );
        //     const { success, role } = response.data;
        //     if (!success || !requiredRole.includes(role)) {
        //       router.push('/login');
        //     }
        //   } catch (error) {
        //     console.error('Error verifying user role:', error);
        //     router.push('/login');
        //   }
        // };
        const verifyUserRole = async () => {
          try {
            const response = await apiRequest(`/api/auth/user-verify-role`,"POST");
            const { success, role } = response;
            if (!success || !requiredRole.includes(role)) {
              router.push('/login');
            }
          } catch (error) {
            console.error('Error verifying user role:', error);
            router.push('/login');
          }
        };
        verifyUserRole();
      }
    }, [router, requiredRole, dispatch]);

    return <WrappedComponent {...props} />;
  };

  // Set display name for debugging purposes
  ComponentWithAuth.displayName = `withAuth(${WrappedComponent.displayName || WrappedComponent.name || 'Component'})`;

  return ComponentWithAuth;
};
export default withAuth