"use client";

import React, { useEffect, useRef, useState } from "react";
import { useRouter } from "next/navigation";
import { deleteCookie, getCookie, setCookie } from "cookies-next";
import { useDispatch, useSelector } from "react-redux";
import { verifyUserRole } from "./lib/features/user/UserSlice";
import { initializeSocket, disconnectSocket } from "./lib/socketManager";
import notificationSound from "@/public/sounds/notification.wav";
import LoadingSpinner from "./LoadingSpinner";
import getDeviceId from "./hooks/useVisitorId";
import axios from "axios";
import { reset } from "./lib/features/chat/chatSlice";
import { fetchShortcuts } from "./lib/features/shortcuts/shortcutsSlice";
 
import swal from 'sweetalert';
import apiRequest from "./lib/InterceptorAxios/axios";
import { fetchTones } from "./lib/features/tones/tonesSlice";
import handlelogout from "./utils/handlelogout";
import { decryptData } from "./utils/DecryptData";
 
const ProtectApp = ({ children }) => {
  const status = useSelector((state) => state.user.status);
  const token = getCookie("token");
  const refreshToken = getCookie("refreshtoken");
  const user = useSelector((state) => state.user.userInfo);
  const [isLoading, setIsLoading] = useState(true);
  const router = useRouter();
  const dispatch = useDispatch();
  const [deviceId, setdeviceId] = useState()
  const userId = useSelector((state) => state.user.userInfo.userId);
  const [Tones, setTones] = useState()
  const selectedBrands = useSelector((state) => state.selectedBrands.selectedBrands);
   // Accessing tones from Redux state
   const { newVisitorTone, messageTone,toneStatus } = useSelector(state => state.tones);
   const newVisitorToneRef = useRef(null); 
  const { tabs, activeTab } = useSelector((state) => state.chat);
 

  const roleBasedRoutes = {
    1: [
      "company-management",
      "brands",
      "chat",
      "all-users",
      "history",
      "profile",
      "settings",
      "team",
      "all-brands",
      "alerts",
    ], // Role 1 can access all routes
    2: [
      "brands",
      "chat",
      "all-users",
      "history",
      "profile",
      "settings",
      "team",
      "test-page"
    ], // Role 2 can access only 'brands' and 'chat'
    4: [
      "brands",
      "chat",
      "all-users",
      "history",
      "profile",
      "settings",
      "team",
    ], // Role 2 can access only 'brands' and 'chat'
    3: ["chat", "brands", "chat", "history", "profile", "settings",], // Role 3 can only access 'chat'
  };
  // Function to check route permission dynamically based on the user's role
  const checkRoute = (role) => {
    

    const currentPath = window.location.pathname.split("/")[1]; // Get the first part of the route
    const allowedRoutes = roleBasedRoutes[role] || []; // Get allowed routes for the role

    if (allowedRoutes.includes(currentPath)) {
      return true; // User is allowed to access this route
    }

    return false; // Block access for other cases
  };
  useEffect(() => {
    const handleVisibilityChange = () => {
      if (document.hidden) {
        // Tab is inactive
              } else {
        // Tab is active
              }
    };

    // Listen for visibility change
    document.addEventListener("visibilitychange", handleVisibilityChange);

    // Cleanup the listener on unmount
    return () => {
      document.removeEventListener("visibilitychange", handleVisibilityChange);
    };
  }, []);
 
  useEffect(() => {
    if (toneStatus === 'succeeded') {
       
       
       newVisitorToneRef.current = newVisitorTone
    }
  }, [toneStatus]);

 
  const selectedBrandsRef = useRef(selectedBrands);

  useEffect(() => {
    selectedBrandsRef.current = selectedBrands;
  }, [selectedBrands]);
  
  
  useEffect(() => {
    if (!token) return; // Exit if no token
  
    // Initialize socket with token
    const initialize = async () => {
      try {
        const socketinst = await initializeSocket(token,refreshToken);
  
        if (!socketinst) return;
  
        // Handle new chat initiation
        const handleNewClient = async (data) => {
          const decryptedData = await decryptData(data);
          const {
            client_id,
            public_key,
            join_time,
            brand_id,
          } =  decryptedData 
          const joinDate = new Date(join_time);
          const now = new Date();
          const isToday = joinDate.toDateString() === now.toDateString();
          const formattedJoinTime = joinDate.toLocaleTimeString("en-US", {
            hour: "numeric",
            minute: "numeric",
            hour12: true,
          });
  
           
  
          const playNotificationSound = () => {
            
            const audio = new Audio(`/sounds/${newVisitorToneRef.current?.file}`);
            audio
              .play()
              .catch((err) => console.error("Error playing sound:", err));
          };
  
          if ( selectedBrandsRef.current.length ===0 || selectedBrandsRef.current.includes(public_key)) {
         
         
            playNotificationSound();
          } else {
           
          }
  
          const showNotification = () => {
            const arrivalTime = new Date().toLocaleTimeString();
            if (Notification.permission === "granted") {
              const notification = new Notification("New Visitor Alert 🚀", {
                body: `Visitor ${client_id} started visiting the website at ${arrivalTime}.`,
                tag: client_id,
                requireInteraction: false,
              });
  
              notification.onclick = () => {
                window.focus();
                window.location.href = `/chat`;
              };
            }
          };
  
          if ("Notification" in window) {
            if (Notification.permission === "default") {
              Notification.requestPermission()
                .then((permission) => {
                  if (permission === "granted") {
                    if (
                      selectedBrandsRef.current.length === 0 ||
                      selectedBrandsRef.current.includes(public_key)
                    ) {
                     
                      showNotification();
                    }
                  } else {
                    console.warn("Notification permission denied");
                  }
                })
                .catch((err) => {
                  console.error("Notification permission request failed", err);
                });
            } else if (Notification.permission === "granted") {
              if (
                selectedBrandsRef.current.length === 0 ||
                selectedBrandsRef.current.includes(public_key)
              ) {
               
                showNotification();
              }
            } else {
              console.warn(
                "Notifications are blocked. Please enable them in your browser settings."
              );
            }
          } else {
            console.error("This browser does not support notifications.");
          }
        };
  
        socketinst.on("new client", handleNewClient);
        socketinst.on("tokens_updated", handleTokenUpdate);
        socketinst.on("refresh_token_error", handleRefreshTokenError);
        
        socketinst.on("Logged_in_to_other_device", (data) => {
          
          const decryptedData = decryptData(data)
          const { message } = decryptedData;
          
          handlelogout(dispatch);
          swal("Oops!", message, "error");
        });
  
        socketinst.emit("get_online_users", {
          user_id: user.userId,
        });
        
        const device_id = localStorage.getItem("visitorId");
        
        
        if (device_id) {
          socketinst.emit("Check_Logged_in_to_other_device", {
            user_id: user.userId,
            device_id,
          });
          
        }
  
        // Clean up on unmount
        return () => {
          socketinst.off("new client", handleNewClient);
          socketinst.off("Logged_in_to_other_device");
        };
      } catch (error) {
        console.error("Error initializing socket:", error);
      }
    };
  
    initialize();
  }, [token]); // Only reinitialize if `token` changes
  const handleTokenUpdate = ({
    accessToken,
    refreshToken
  })=>{
    setCookie('token', accessToken);
    setCookie('refreshToken', refreshToken);
    
  }
  const handleRefreshTokenError = () => {
    // Handle refresh token error
    console.error("Refresh token error");
  handlelogout(dispatch);
    };
  // const handleLogout = async () => {
  //   try {
  //     // Call the logout API
  //     setInterval(() => {
  //       disconnectSocket();
        
  //     }, 500);
  //     await axios.post(`${process.env.NEXT_PUBLIC_API_URL}/api/auth/logout`);
  //     dispatch(reset());
  //   } catch (error) {
  //     console.error('Error logging out:', error);
  //   } finally {
  //     // Remove the token cookie
  //     deleteCookie('token');
  //     // Redirect to the login page
  //     window.location.href = '/login'; 
  //   }
  // };
  useEffect(() => {
    if (!token) {
  
      // If there's no token, redirect to login page
      router.push("/login");
      setIsLoading(false); // Stop loading once redirected
    } else {
      if (user && user.length > 0) {
        // If user data exists, verify the role and check routes
   
   
        const isAllowed = checkRoute(user.role);
        if (!isAllowed) {
          router.push("/"); // Redirect to "not authorized" page
        }
        setIsLoading(false); // Stop loading once checks are done
      } else {
      
        // If no user data, dispatch to verify user role
        dispatch(verifyUserRole(token)).then((userData) => {
          if (userData?.payload?.role) {
            const isAllowed = checkRoute(userData.payload.role);
            if (!isAllowed) {
              router.push("/"); // Redirect to "not authorized" page
            }
          
            dispatch(fetchTones(userData.payload.userId));
            const companyId = userData.payload.company_id
            const userId = userData.payload.userId
              dispatch(fetchShortcuts({companyId,userId}));
            setIsLoading(false); // Stop loading once checks are done
          }
        });
      }
    }
  }, [token, dispatch, router]);

  useEffect(() => {
    if (status === "succeeded") {
       
      return () => {
        // disconnectSocket();
      };
    }
  }, [status, token]);
  if (isLoading) {
    return <LoadingSpinner />;
  }
  
  return <>{user.roleVerified == true ? <>{children}</> : null}</>;
};

export default ProtectApp;
