import { configureStore } from '@reduxjs/toolkit';
import userReducer from './features/user/UserSlice';
import socketReducer from './features/socket/socketSlice';
import chatReducer from './features/chat/chatSlice';
import selectedBrandsReducer from './features/chat/selectedBrandsSlice';
import shortcutsReducer from './features/shortcuts/shortcutsSlice';
import tonesReducer from './features/tones/tonesSlice';

export const makeStore = () => {
  return configureStore({
    reducer: {
      user: userReducer,
      socket: socketReducer,
      chat: chatReducer,
      shortcuts: shortcutsReducer,
      tones: tonesReducer,
      selectedBrands: selectedBrandsReducer,
    },
  });
};
