'use client'
import React from 'react';

class ErrorBoundary extends React.Component {
  constructor(props) {
    super(props);
    this.state = { hasError: false, error: null, errorInfo: null };
  }

  static getDerivedStateFromError(error) {
    // Update state to show fallback UI
    return { hasError: true };
  }

  componentDidCatch(error, errorInfo) {
    // Log the error or send it to an error reporting service
    console.error('Error caught by Error Boundary:', error, errorInfo);
    this.setState({ error, errorInfo });
  }

  render() {
    if (this.state.hasError) {
      // Filter stack traces to show only your app's code
      const filteredStack = this.state.errorInfo?.componentStack
        ?.split('\n')
        ?.filter(line => line.includes('./app/') || line.includes('./src/')) // Adjust based on your project structure
        ?.join('\n');

      return (
        <div style={{ padding: '1rem', fontFamily: 'monospace' }}>
          <h2>⚠️ Application Error</h2>
          <p><strong>{this.state.error?.toString()}</strong></p>
          
          {filteredStack && (
            <div style={{ marginTop: '1rem' }}>
              <p>Location:</p>
              <pre style={{
                background: '#f0f0f0',
                padding: '1rem',
                borderRadius: '4px',
                overflowX: 'auto'
              }}>
                {filteredStack}
              </pre>
            </div>
          )}
        </div>
      );
    }
    return this.props.children;
  }
}

export default ErrorBoundary;