// handleLogout.js - A utility function for logout
import { reset } from '../lib/features/chat/chatSlice';
import { disconnectSocket } from '../lib/socketManager';
import { deleteCookie } from 'cookies-next';
import axios from 'axios';

const handlelogout = async (dispatch) => { // Receive dispatch here
    try {
        // Disconnect the socket before logging out
        disconnectSocket();

        // Call the logout API
        await axios.post(`${process.env.NEXT_PUBLIC_API_URL}/api/auth/logout`, {}, {
            headers: {
                Authorization: `Bearer ${getCookie('token')}`,
                'x-refresh-token': getCookie('refreshtoken')
            }
        });

        // Dispatch the reset action
        dispatch(reset());
    } catch (error) {
        console.error('Error logging out:', error);
        deleteCookie('token');
        deleteCookie('refreshToken');
    } finally {
        // Remove both the access token and refresh token cookies
        deleteCookie('token');
        deleteCookie('refreshToken');

        // Redirect to the login page
        window.location.href = '/login';
    }
};

export default handlelogout;
